<!DOCTYPE html>
<html>
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>Payment Analytics Report</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            margin: 0;
            padding: 0;
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            font-size: 12px; /* Reduce font size for fitting */
        }
        th, td { 
            border: 1px solid #ddd; 
            padding: 6px; /* Reduce padding */
            text-align: left; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        @page {
            size: landscape; /* Set the page size to landscape */
            margin: 10mm; /* Adjust margin if needed */
        }
    </style>
</head>
<body>
    <h1>Payment Analytics Report</h1>
    <p>Generated on: {{ now()->format('d.m.Y H:i') }}</p>

    <table class="table">
        <thead>
            <tr>
                <th>Booking ID</th>
                <th>Payment ID</th>
                <th>Customer Name</th>
                <th>Date</th>
                <th>Payment Method</th>
                <th>Amount (€)</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($bookings as $booking)
            <tr>
                <td>#{{ $booking->id }}</td>
                <td>{{ $booking->stripe_payment_intent ?? 'N/A' }}</td>
                <td>{{ $booking->userDetails ? $booking->userDetails->first_name.' '.$booking->userDetails->last_name : 'N/A' }}</td>
                <td>{{ $booking->created_at->format('d.m.Y') }}</td>
                <td>{{ $booking->payment_method ?? 'N/A' }}</td>
                <td>{{ number_format($booking->total, 2, ',', '.') }} €</td>
                <td>
                    @switch($booking->payment_status)
                        @case('paid') Completed @break
                        @case('unpaid') Canceled @break
                        @case('refund') Refunded @break
                        @case('reconciliation') Reconciliation @break
                        @default {{ $booking->payment_status }}
                    @endswitch
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</body>
</html>